import java.rmi.registry.*;
/**
 * Classe che sceglie in modo casuale quale server sar poi associato
 * ad un certo client del newsgroup, tra quelli attivi al momento
 * della richiesta del client
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */
public class ChooseServerRandom implements IChooseServer{
	int i=0;
	protected RegistryInfo reg;
	/**
	 * Costruttore di ChooseServerRandom con in ingresso un
	 * riferimento a una classe di tipo RegistryInfo, cjhe contiene le
	 * informazioni dell'host e delle porte dei registri
	 * @param r istanza di RegistryInfo
	 */
	public ChooseServerRandom(RegistryInfo r){
		reg=r;
	}
	
	/**
	 * Metodo che ritorna il nome di un server scelto a caso
	 * @return nome del server attivo scelto da associare poi al cliente
	 */
	public String whichServer(){
		try{
			Registry registry=LocateRegistry.getRegistry(RegistryInfo.getSecondLevelPortNum());
			String[] servers=registry.list();
			int maxDim=servers.length;
			String name=null;
			do{
				Long randomNum=new Long(Math.round(Math.random()*30));
				int  index=randomNum.intValue()%maxDim;
				name=servers[index];
			}while(name==null);
			return name;
		}
		catch(Exception e){
			return null;
		}
	}
	
	/**
	 * Metodo che ritorna il numero di servizi che appaiono
	 * registrati nel registry di secondo livello
	 * @return numero di server registrati nel registry di secondo livello. In caso di
	 * 	eccezione ritorna il valore 0
	 */
	public int numServers(){
		try{
			Registry registry=LocateRegistry.getRegistry(RegistryInfo.getSecondLevelPortNum());
			return registry.list().length; 
		}
		catch (Exception e){
			return 0;
		}
	}
}
